﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Threading;
using System.Reflection;

namespace TwoCamWPF.Helpers
{
	
	struct VideoBackuper
	{
        EventHandler finishCallback;
        FileInfo[] files;
        string dest;
        private void DoFinish()
        {
            if (finishCallback != null)
                finishCallback(this, EventArgs.Empty);
        }


		private VideoBackuper(FileInfo[] files, string dest, EventHandler finishCallback)
		{
			this.files = files;
			this.finishCallback = finishCallback;
            this.dest = dest;
		}

        public static void Copy(FileInfo[] files, string dest, EventHandler finishCallback)
        {
            VideoBackuper v = new VideoBackuper(files, dest, finishCallback);
            Thread thread = new Thread(new ParameterizedThreadStart(CopyThread));
            thread.Priority = ThreadPriority.Lowest;
            thread.Start(v);
        }

		private static void CopyThread(object param)
		{

           
            VideoBackuper info = (VideoBackuper)param;
			try
			{
				Directory.CreateDirectory(info.dest);
			}
			catch (Exception e)
			{
                Log.LogClass.Enqueue(MethodBase.GetCurrentMethod(), "Ошибка создания директории " + info.dest);
                Log.LogClass.Enqueue(MethodBase.GetCurrentMethod(), e.Message);
                info.DoFinish();
				return;
			}

            for (int index = 0; index < info.files.Length; ++index)
			{
				try
				{
                    File.Copy(info.files[index].FullName, info.dest + info.files[index].Name);
				}
				catch { }
			}
            info.DoFinish();
		}



	}
}
